﻿
using System.Collections;

int[] fibNumbers = new int[] { 0, 1, 1, 2, 3, 5, 8, 13 };
foreach (int number in fibNumbers) {
    Console.WriteLine($"{number}");
}

IEnumerable<int> FibNumbers(int n){
    yield return 0;
    yield return 1;

    int a = 0;
    int b = 1;
    for(int i=1;i<n;i++){
        int next = a+b;
        yield return next;
        a = b;
        b = next;
    }
}

foreach (int number in FibNumbers(7)) {
    Console.WriteLine($"{number}");
}

var fibNumbers = new FibNumbers(7);
foreach(int number in fibNumbers){
    Console.WriteLine($"{number}");
}

class FibNumbers : IEnumerable<int>{
    int n;
    FibNumbersEnumerator e;
    public FibNumbers(int n){
        this.n = n;
        this.e = new FibNumbersEnumerator(this.n);
    }
    public IEnumerator<int> GetEnumerator(){
        return this.e;
    }
    IEnumerator IEnumerable.GetEnumerator(){
        return this.GetEnumerator();
    }
}

class FibNumbersEnumerator : IEnumerator<int>{
    int n;
    int a;
    int b;
    int index;
    public FibNumbersEnumerator(int n){
        this.n = n;
        this.Reset();
    }

    public int Current{
       get { return this.a; }
    }

    object IEnumerator.Current{
       get { return this.Current; }
    }

    public bool MoveNext(){
       if(this.index<1){
            this.a = 0;
            this.b = 1;
       }else{
            int next = this.a+this.b;
            this.a = this.b;
            this.b = next;
            
       }
       
       this.index +=1;
       if(this.index==this.n+2){
           return false;
       }else{
           return true;
       }
    }

    public void Reset(){
        this.a = 0;
        this.b = 0;
        this.index = 0;
    }

    public void Dispose(){}
}



int FibNumbers(int n){
    if(n==0) return 0;
    if(n==1) return 1;
    return FibNumbers(n-1) + FibNumbers(n-2);
}

foreach (int number in FibNumbers(7)) {
    Console.WriteLine($"{number}");
}